#
#
#

#
# %list = getCookieName($ENV{'HTTP_COOKIE'}, $KeyName);
#   $cookie_list{'name'}
#      => get value of 'name' in $KeyName on $ENV{'HTTP_COOKIE'}
#
sub getCookieName {
  local($cookie_str, $cookie_name) = @_;
  local($cent, $nam, $val, $ccent, $cnam, $cval);
  local(%narray) = ();
  local(%jhtCookieList) = ();

  foreach $cent ( split(/;/, $cookie_str) ) {
    ($nam, $val) = split(/=/,$cent);
    $nam =~ s/ //g;
    %narray = ( %narray, $nam, $val );
  }
  foreach $ccent (split(/\//,$narray{$cookie_name}) ) {
    ($cnam, $cval) = split(/\!/,$ccent);
    $cnam =~ s/%21/\!/g;   $cval =~ s/%21/\!/g;    
    $cnam =~ s/%2F/\//g;   $cval =~ s/%2F/\//g;    
    $cnam =~ s/%3D/\=/g;   $cval =~ s/%3D/\=/g;    
    $cnam =~ s/%3B/\;/g;   $cval =~ s/%3B/\;/g;    
    %jhtCookieList = ( %jhtCookieList, $cnam, $cval );
  }
  return(%jhtCookieList);
}

#
# setCookieName($Name, @pair_of_entry)
# Display 'Set-Cookie: '. to set cookie.
# Cookie will be set to follows format.
#  $Name = ${entryName1}!${entryValue1}[/${entryName_n}!${entryValue_n}];
#
sub setCookieName {
  local($cookie_name, %ent_list) = @_;
  local($e_cookie) = "";
  local ($sc,$mn,$hr,$dy,$mt,$yr,$wd,$yd,$id) = localtime(time + 30*24*60*60);

  $yr = sprintf("%04d",$yr+1900); $sc = sprintf("%02d",$sc);
  $mn = sprintf("%02d",$mn); $hr = sprintf("%02d",$hr);
  $dy = sprintf("%02d",$dy);
  $y0="Sunday"; $y1="Monday"; $y2="Tuesday"; $y3="Wednesday"; $y4="Thursday";
  $y5="Friday"; $y6="Saturday";
  $yb = ($y0,$y1,$y2,$y3,$y4,$y5,$y6) [$wd];
  $m0="Jan"; $m1="Feb"; $m2="Mar"; $m3="Apr"; $m4="May"; $m5="Jun";
  $m6="Jul"; $m7="Aug"; $m8="Sep"; $m9="Oct"; $m10="Nov"; $m11="Dec";
  $mt = ($m0,$m1,$m2,$m3,$m4,$m5,$m6,$m7,$m8,$m9,$m10,$m11) [$mt] ;
  $exp_format =  "expires=$yb, ${dy}-${mt}-${yr} ${hr}:${mn}:${sc} GMT";
  while ( ($nam,$val) = each(%ent_list) ) {
    chop($nam) if $nam =~ /\n$/;
    chop($val) if $val =~ /\n$/;
    $nam =~ s/!/%21/g;   $val =~ s/!/%21/g;    
    $nam =~ s/\//%2F/g;  $val =~ s/\//%2F/g;    
    $nam =~ s/\=/%3D/g;  $val =~ s/\=/%3D/g;    
    $nam =~ s/\;/%3B/g;  $val =~ s/\;/%3B/g;    
    if ( $e_cookie eq '' ) { $e_cookie = "${nam}!${val}" ; }
    else                   { $e_cookie = "${e_cookie}/${nam}!${val}"; }
  }
  print "Set-Cookie: ${cookie_name}=${e_cookie}; ${exp_format}\n";
  return ;
}

1;
