;#
;#                jhtdecode.pl
;#                                                 RVN19693 A-SA
;#                                                 <morning@mvf.biglobe.ne.jp>
;#
;#           v0.0.1 : 07/07/1997
;#           v0.0.2 : 07/09/1997
;#           v0.0.3 : 12/10/1997 - Japanese comment purged.
;#           v0.0.4 : 30/10/1997 - function jhtKcode() added.
;#           v0.0.5 : 06/11/1997 - Bug fux: at JIS code on jhtDecodeNoTag()
;#           v1.0.0 : 11/11/1997 - pack() function used.
;#
;# usage: &jhtDecode(jCode, str)
;#    jCode  : KANJI code for output('euc', 'sjis', 'jis')
;#    str    : strings to be convert
;#
;# example:
;#    Decode $oStr and convert to euc code, set to $dStr
;#    $dStr = &jhtDecode('euc',$oStr);
;#
;#
require './jcode.pl' ;

sub jhtDecode {
    local($code, $oline) = @_;
    $line = $oline;
    if ( $line =~ /\+/ ) { $line =~ s/\+/ /g; }
    $line =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    # &jcode'convert(*line, 'euc') if $code ne 'euc';
    &jcode'convert(*line, $code);
    return $line;
}

sub jhtDecodeNoTag {
    local($code, $oline) = @_;
    $line = $oline;
    $line =~ s/\+/ /g		if $line =~ /\+/;
    $line =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    &jcode'convert(*line, 'euc') if $code ne 'euc';
    $line =~ s/\&/&amp;/g	if $line =~ /\&/;
    $line =~ s/\"/&quot;/g	if $line =~ /\"/;
    $line =~ s/\</&lt;/g	if $line =~ /\</;
    $line =~ s/\>/&gt;/g	if $line =~ /\>/;
    &jcode'convert(*line, $code);

    return $line;
}

sub jhtKcode {
    local($code, $line) = @_;
    &jcode'convert(*line, $code);
    return $line;
}

1;
